<?php

    namespace App\Controllers\Api;

    use CodeIgniter\RESTful\ResourceController;
    use CodeIgniter\API\ResponseTrait;
    use App\Models\SuppliersModel;

    class Supplier extends ResourceController
    {
        use ResponseTrait;

        public function index()
        {
            $SuppliersModel = new SuppliersModel();
            $Suppliers['Suppliers'] = $SuppliersModel->orderBy('person_id', 'DESC')->findAll();
            return $this->respond($Suppliers);
        }
        // create supplier
        public function create() {
            $model = new SuppliersModel();
            $data = [
                'person_id' => $this->request->getPost('person_id'),
                'company_name' => $this->request->getPost('company_name'),
                'account_number' => md5($this->request->getPost('account_number')),
                'deleted' => $this->request->getPost('deleted')
            ];
            $model->insert($data);
            $response = [
                'status'   => 201,
                'error'    => null,
                'messages' => [
                    'success' => 'Supplier created successfully'
                ]
            ];
            return $this->respondCreated($response);
        }
        // single user
        public function show($id = null){
            $model = new SuppliersModel();
            $data = $model->where('person_id', $id)->first();
            if($data){
                return $this->respond($data);
            }else{
                return $this->failNotFound('No Supplier found');
            }
        }        
        // update
        public function update($id = null){
            $model = new SuppliersModel();
            $id = $this->request->getVar('id');
            $data = [
                'company_name' => $this->request->getVar('company_name'),
                'account_number' => md5($this->request->getVar('account_number'))
            ];
            $model->update($id, $data);
            $response = [
                'status'   => 200,
                'error'    => null,
                'messages' => [
                    'success' => 'Supplier updated successfully'
                ]
            ];
            return $this->respond($response);
        }
        // delete
        public function delete($id = null){
            $model = new SuppliersModel();
            $data = $model->where('person_id', $id)->delete($id);
            if($data){
                $model->delete($id);
                $response = [
                    'status'   => 200,
                    'error'    => null,
                    'messages' => [
                        'success' => 'Supplier successfully deleted'
                    ]
                ];
                return $this->respondDeleted($response);
            }else{
                return $this->failNotFound('No Supplier found');
            }
        }
    }

?>